'=========================================================
'Program pengendalian motor steper dari PLC Keyence KV-40
'
'oleh: Mada Jimmy
'website: http://madajimmy.com
'
'=========================================================
Public Class mainControl
    Dim WithEvents serialPort As New IO.Ports.SerialPort

    Private Sub Form1_Load( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles MyBase.Load

        For i As Integer = 0 To _
           My.Computer.Ports.SerialPortNames.Count - 1
            cbbCOMPorts.Items.Add( _
               My.Computer.Ports.SerialPortNames(i))
        Next
        btnDisconnect.Enabled = False
    End Sub

    Private Sub DataReceived( _
       ByVal sender As Object, _
       ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) _
       Handles serialPort.DataReceived

        txtDataReceived.Invoke(New _
                       myDelegate(AddressOf updateTextBox), _
                       New Object() {})
    End Sub



    Public Delegate Sub myDelegate()
    Public Sub updateTextBox()
        With txtDataReceived
            .Font = New Font("Courrier", 12.0!, FontStyle.Bold)
            .SelectionColor = Color.Blue
            .AppendText(serialPort.ReadExisting)
            .ScrollToCaret()
        End With
    End Sub

    Private Sub btnConnect_Click( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles btnConnect.Click
        If serialPort.IsOpen Then
            serialPort.Close()
        End If
        Try
            With serialPort
                .PortName = cbbCOMPorts.Text
                .BaudRate = 9600
                .Parity = IO.Ports.Parity.Even
                .DataBits = 8
                .StopBits = IO.Ports.StopBits.One
                .Encoding = System.Text.Encoding.ASCII
            End With
            serialPort.Open()

            lblMessage.Text = cbbCOMPorts.Text & " connected."
            btnConnect.Enabled = False
            btnDisconnect.Enabled = True
        Catch ex As Exception
            MsgBox(ex.ToString)
        End Try
    End Sub

    Private Sub btnDisconnect_Click( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles btnDisconnect.Click
        Try
            serialPort.Close()
            lblMessage.Text = serialPort.PortName & " disconnected."
            btnConnect.Enabled = True
            btnDisconnect.Enabled = False
        Catch ex As Exception
            MsgBox(ex.ToString)
        End Try
    End Sub



    Private Sub ButtonOff_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub






    Private Sub ButtonmOn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonmOn.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("ST 1000" & vbCrLf)
        serialPort.Write("RS 1000" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonCCW_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCCW.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("RS 501" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonCW_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCW.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("ST 501" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonOff_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOff.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("ST 1001" & vbCrLf)
        serialPort.Write("RS 1001" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub




    Private Sub ButtonStartPulse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonStartPulse.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("WR DM1480 " & TextBoxStartPulse.Text & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonOprPulse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOprPulse.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("WR DM1481 " & TextBoxOprPulse.Text & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonAccDec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonAccDec.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("WR DM1482 " & TextBoxAccDec.Text & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonNoPulseHi_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonNoPulseHi.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("WR DM1485 " & TextBoxNoPulseHi.Text & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonNoPulseLo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonNoPulseLo.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("WR DM1484 " & TextBoxNoPulseLo.Text & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)

    End Sub

    Private Sub ButtonRUN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonRUN.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("M1" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub

    Private Sub ButtonSTOP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSTOP.Click
        serialPort.Write("CR" & vbCrLf)
        serialPort.Write("M0" & vbCrLf)
        serialPort.Write("CQ" & vbCrLf)
    End Sub
End Class
